clear all; close all; clc

load('D50_a.mat');
load('D50_b.mat');
load('D100_a.mat');
load('D100_b.mat');
load('D200_a.mat');
load('D200_b.mat');
load('D300_a.mat');
load('D300_b.mat');
load('D400_a.mat');
load('D400_b.mat');
load('D500_a.mat');
load('D500_b.mat');
load('D600_a.mat');
load('D600_b.mat');
load('D700_a.mat');
load('D700_b.mat');


Tb1_monthly_avg=[Tb1_monthly_avg_a' Tb1_monthly_avg_b Tb1_monthly_avg_c Tb1_monthly_avg_d Tb1_monthly_avg_e Tb1_monthly_avg_f Tb1_monthly_avg_g Tb1_monthly_avg_h];
Tb1_std=[Tb1_std_a' Tb1_std_b Tb1_std_c Tb1_std_d Tb1_std_e Tb1_std_f Tb1_std_g Tb1_std_h ]; 

Tf1_monthly_avg=[Tf1_monthly_avg_a' Tf1_monthly_avg_b Tf1_monthly_avg_c Tf1_monthly_avg_d Tf1_monthly_avg_e Tf1_monthly_avg_f Tf1_monthly_avg_g Tf1_monthly_avg_h];
Tf1_std=[Tf1_std_a' Tf1_std_b Tf1_std_c Tf1_std_d Tf1_std_e Tf1_std_f Tf1_std_g Tf1_std_h ]; 


figure(1)
subplot(2,1,1)
errorbar(1:12, Tb1_monthly_avg, Tb1_std, 'o-', 'LineWidth', 1.5);
legend('k_{fill} = 0.5 W/mK','k_{fill} = 0.78 W/mK', 'k_{fill} = 1.1 W/mK', 'k_{fill} = 1.4 W/mK', 'k_{fill} = 1.6 W/mK', 'k_{fill} = 1.9 W/mK', 'k_{fill} = 2.2 W/mK');
set(gca,'fontsize',25)
grid on;
title('Temperature profile (Borehole)');
xlabel('Time (month)');
ylabel('Temperature (°C)');

subplot(2,1,2)
errorbar(1:12, Tf1_monthly_avg, Tf1_std, 'o-', 'LineWidth', 1.5);
legend('k_{fill} = 0.5 W/mK','k_{fill} = 0.78 W/mK', 'k_{fill} = 1.1 W/mK', 'k_{fill} = 1.4 W/mK', 'k_{fill} = 1.6 W/mK', 'k_{fill} = 1.9 W/mK', 'k_{fill} = 2.2 W/mK');
set(gca,'fontsize',25)
grid on;
title('Temperature profile (Fluid)');
xlabel('Time (month)');
ylabel('Temperature (°C)');